
if ( SERVER ) then

	AddCSLuaFile( "shared.lua" )
	
end

if ( CLIENT ) then

	SWEP.PrintName			= "Rocket Launcher"			
	SWEP.Slot				= 4
	SWEP.SlotPos			= 4
	SWEP.ViewModelFOV		= 85
	SWEP.WepSelectIcon		= surface.GetTextureID( "vgui/h_bazooka" )
	
	killicon.Add( "kingpin_rpgk", "vgui/ah_bazooka", Color( 255, 80, 0, 255 ) )
end
function SWEP:DryFire()
	self.Weapon:EmitSound("weapons/v_pipebar/noammo.wav")
end
function SWEP:PrimaryAttack()
	if not IsValid(self.Owner) or self.Owner:Health() < 0 or !self:CanPrimaryAttack() then return end
	self.Weapon:SetNextPrimaryFire(CurTime() +self.Primary.Delay)	
	self:TakePrimaryAmmo(1)
	self.Weapon:SendWeaponAnim(ACT_VM_PRIMARYATTACK)
	self.Weapon:EmitSound( self.Primary.Sound )
	self.Owner:SetAnimation( PLAYER_ATTACK1 )
	if SERVER then
		local pos = self.Owner:GetShootPos()
		local ang = self.Owner:GetAimVector():Angle()
pos = pos +ang:Forward() *-40 +ang:Right() *5 +ang:Up() *-6
		local ent = ents.Create("kp_rocket")
		ent:SetAngles(ang)
		ent:SetPos(pos)
		ent:SetEntityOwner(self.Owner)
		ent:Spawn()
		ent:Activate()
		local phys = ent:GetPhysicsObject()
		if IsValid(phys) then
			phys:SetVelocity(ang:Up() *40 +ang:Forward() *800)
		end	
	end
	
end
function SWEP:Reload()
if ( self.Weapon:Ammo1() <= 0 ) then return end
	if ( self.Weapon:Clip1() >= self.Primary.ClipSize ) then return end
	self.Weapon:DefaultReload( ACT_VM_RELOAD )
	self:EmitSound( "v_rpgk/reload.wav" )
end

function SWEP:Deploy()
	self.Weapon:SetNextPrimaryFire(CurTime() +.6)
	self.Weapon:SendWeaponAnim(ACT_VM_DRAW)

	return true
end

function SWEP:SecondaryAttack()	
end
function SWEP:Holster()
	
	return true
	end


SWEP.HoldType			= "physgun"
SWEP.Base				= "kingpin_base"
SWEP.Category			= "Kingpin"
SWEP.BobScale	= 0.3
SWEP.SwayScale	= 0.1
SWEP.Spawnable			= true
SWEP.AdminSpawnable		= true

SWEP.ViewModel			= "models/weapons/v_rpgk.mdl"
SWEP.WorldModel			= "models/weapons/w_rpgk.mdl"

SWEP.Weight				= 3
SWEP.AutoSwitchTo		= false
SWEP.AutoSwitchFrom		= false
SWEP.Force				= 1000
SWEP.Primary.Sound			= Sound( "v_rpgk/rl_fire.wav" )
SWEP.Primary.Recoil			= 0
SWEP.Primary.Damage			= 0
SWEP.Primary.NumShots		= 1
SWEP.Primary.Cone			= 0.03
SWEP.Primary.ClipSize		= 5
SWEP.Primary.Delay			= 0.8
SWEP.Primary.DefaultClip	= 5
SWEP.Primary.Automatic		= true
SWEP.Primary.Ammo			= "RPG_Round"